function [MSScode] = FRWZ_msscheck(P,hx)
% constructs the matrix T and checks eigenvalues for a given solution to
%  a Markov-Switching model; see Costa et al (2005)
% 
% Andrew Foerster
% edited 2013/12/18
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
% INPUTS
%  P = (ns x ns) matrix, transition matrix for regimes
%  hx = (ns x 1) cell, solution to MS model with hx{s} 
%       is the solution given regime s
% 
% 
% OUTPUTS
%  MSScode = boolean
%      = 0 if an eigenvalue is greater than 1 in modulus, so not MSS
%      = 1 if abs(eig(T))<1 so system is mean square stable
% 
% 
% CALLS
%  None
% 
%  
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

% -- Inputs -- %
ns = size(P,1);
nx = size(hx{1},1);


% -- Constructing Matrix -- %
C = kron(P',eye(nx^2,nx^2));
N = zeros(ns*nx*nx,ns*nx*nx);
for ii = 1:ns;
    N((ii-1)*nx*nx+1:ii*nx*nx,(ii-1)*nx*nx+1:ii*nx*nx) ...
        = kron(hx{ii},hx{ii});
end;
T = C*N;

% -- Checking Eigenvalues -- %
if max(abs(eig(T))) < 1;
    MSScode = 1;
else
    MSScode = 0;
end;